package gov.va.med.mhv.sm.admin.web.validator;

import java.util.ArrayList;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "ZipCodeValidator")
public class ZipCodeValidator implements Validator {

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String zipcode = (String) value;

		if (zipcode == null || zipcode.isEmpty()) {
			return; // Let required="true" or @NotNull handle it.
		}

		if (zipcode.length() < 5) {
			String summary1 = "Your zip code does not match a region in our system. Please re-enter your 5 digit zip code, or leave the field blank and click \"Save.\" If you leave the field blank, your calendar will not display VHA Events associated with your zip code.";
			String summary2 = "The zip code must contain 5 numbers.";
			String detail1 = "Your zip code does not match a region in our system. Please re-enter your 5 digit zip code, or leave the field blank and click \"Save.\" If you leave the field blank, your calendar will not display VHA Events associated with your zip code.";
			FacesMessage msg1 = new FacesMessage(FacesMessage.SEVERITY_ERROR, summary1, detail1);
			FacesMessage msg2 = new FacesMessage(FacesMessage.SEVERITY_ERROR, summary2, null);
			List<FacesMessage> list1 = new ArrayList<FacesMessage>();
			list1.add(msg1);
			list1.add(msg2);
			throw new ValidatorException(list1);
		}
	}
}
